<?php

bx_import('BxBaseCaptchaReCAPTCHA');

/**
 * @see BxDolCaptcha
 */

$UsePlaythru = getParam('sys_playthru_use_playthru');
if($UsePlaythru != 'on') {
class BxTemplCaptchaReCAPTCHA extends BxBaseCaptchaReCAPTCHA
{
    public function __construct ($aObject, $oTemplate = false)
    {
        parent::__construct ($aObject, $oTemplate);
    }
}
} else {
class BxTemplCaptchaReCAPTCHA extends BxBaseCaptchaReCAPTCHA
{
    private $ayah;
	protected $_sKeyPublisher;
	protected $_sKeyScoring;
    public function __construct ($aObject, $oTemplate = false)
    {
        parent::__construct ($aObject, $oTemplate);
        
		$this->_sKeyPublisher = getParam('sys_playthru_key_publisher');
        define('AYAH_PUBLISHER_KEY', $this->_sKeyPublisher);
		
		$this->_sKeyScoring = getParam('sys_playthru_key_scoring');
        define('AYAH_SCORING_KEY', $this->_sKeyScoring);
		
        require_once(BX_DIRECTORY_PATH_PLUGINS . 'playthru/ayah.php');

        $this->_ayah = new AYAH();

    }
    
    /**
     * Display captcha.
     */
    public function display ($bDynamicMode = false)
    {
        return $this->_ayah->getPublisherHTML();
    }
    
    /**
     * Check captcha.
     */
    public function check ()
    {

        $score = $this->_ayah->scoreResult();
        if ($score) {
            return true;
        }
        else {
            return false;
        }
    }
	
    /**
     * Check if captcha is available, like all API keys are specified.
     */
	public function isAvailable ()
    {
        return !empty($this->_sKeyPublisher) && !empty($this->_sKeyScoring);
    }

}
}