<?php

/**
 * Copyright (c) BoonEx Pty Limited - http://www.boonex.com/
 * CC-BY License - http://creativecommons.org/licenses/by/3.0/
 */

bx_import('BxBaseMenu');

/**
* @see BxBaseMenu;
*/
class BxTemplMenu extends BxBaseMenu
{
	var $aProfileOwnerSubmenu;

    /**
    * Class constructor;
    */
    function BxTemplMenu()
    {
        parent::BxBaseMenu();
    }
    function setCustomSubActions(&$aKeys, $sActionsType, $bSubMenuMode = true)
    {
    	parent::setCustomSubActions($aKeys, $sActionsType, $bSubMenuMode);

    	$this->sCustomActions = $GLOBALS['oSysTemplate']->parseHtmlByContent($this->sCustomActions, array(
    		'popup' => $GLOBALS['oFunctions']->transBox(
    			$GLOBALS['oSysTemplate']->parseHtmlByName('share_popup.html', array())
    		)
    	));
    }
    function genTopSubitems($iItemID)
    {
    	return '';
    }
    function genSubItems($iTItemID = 0)
    {
        $sSubItems = '';
        foreach( $this->aTopMenu as $iItemID => $aItem ) {
            if( $aItem['Type'] != 'custom' )
                continue;
            if( $aItem['Parent'] != $iTItemID )
                continue;
            if( !$this->checkToShow( $aItem ) )
                continue;

            //generate
            list( $aItem['Link'] ) = explode( '|', $aItem['Link'] );

            $aItem['Link']    = $this->replaceMetas( $aItem['Link'] );
            $aItem['Onclick'] = $this->replaceMetas( $aItem['Onclick'] );
            $sSubItems .= $this->genSubItem( _t( $aItem['Caption'] ), $aItem['Link'], $aItem['Target'], $aItem['Onclick'], $iItemID == $this->aMenuInfo['currentCustom']);

            $bFirst = false;
        }
    	if(empty($sSubItems))
    		return '';

    	$iSelected = (int)$this->aMenuInfo['currentCustom'] > 0 ? (int)$this->aMenuInfo['currentCustom'] : $this->getSubItemFirst($this->aMenuInfo['currentTop']);
    	$aSelected = $this->aTopMenu[$iSelected];

    	return $GLOBALS['oSysTemplate']->parseHtmlByName('navigation_menu_sub_header_submenu.html', array(
    		'link' => $aSelected['Link'],
    		'onclick' => 'javascript:return oBxEvoTopMenu.showSubmenuSubmenu(this);',
    		'caption' => _t($aSelected['Caption']),
    		'submenu' => $sSubItems
    	));

    }

    function genSubItem( $sCaption, $sLink, $sTarget, $sOnclick, $bActive )
    {
		$sOnclick = $sOnclick ? ' onclick="' . $sOnclick . '"' : '';
		$sTarget = $sTarget  ? ' target="'  . $sTarget  . '"' : '';

		if(strpos( $sLink, 'http://' ) === false && strpos( $sLink, 'https://' ) === false && !strlen($sOnclick))
        	$sLink = $this->sSiteUrl . $sLink;

		return '<div class="sub-two-column ' . ($bActive ? 'act' : 'pas') . '"><a class="sublinks" href="' . $sLink . '"' . $sTarget . $sOnclick . '>' . $sCaption . '</a></div>';
    }

    function getSubItemFirst($iTItemID = 0)
    {
    	$iResult = 0;
    	foreach( $this->aTopMenu as $iItemID => $aItem ) {
            if( $aItem['Type'] != 'custom' )
                continue;
            if( $aItem['Parent'] != $iTItemID )
                continue;
            if( !$this->checkToShow( $aItem ) )
                continue;

			$iResult = $iItemID;
			break;
    	}

    	return $iResult;
    }

    function genSubHeaderCaption($aItem, $sCaption, $sTemplateFile = 'navigation_menu_sub_header_caption.html')
    {
    	return '';
    }

    function genSubHeaderLogin($sTemplateFile = 'login_join.html')
    {
    	$sContent = parent::genSubHeaderLogin($sTemplateFile);

    	return $GLOBALS['oSysTemplate']->parseHtmlByContent($sContent, array(
    		'popup' => $GLOBALS['oFunctions']->transBox(
    			$GLOBALS['oSysTemplate']->parseHtmlByName('share_popup.html', array())
    		)
    	)); 
    }

    function GenMoreElementBegin()
    {
        return $GLOBALS['oSysTemplate']->parseHtmlByName('navigation_menu_mm_item.html', array(
        	'link' => 'javascript:void(0)',
        	'bx_if:show_active' => array(
        		'condition' => false,
        		'content' => array()
        	),
        	'bx_if:show_onclick' => array(
        		'condition' => true,
        		'content' => array(
        			'onclick' => "$(this).parents('td.top:first').hide().siblings('td.top:hidden').show();"
        		)
        	),
        	'bx_if:show_target' => array(
        		'condition' => false,
        		'content' => array()
        	),
        	'bx_if:show_style' => array(
        		'condition' => false,
        		'content' => array()
        	),
        	'bx_if:show_picture' => array(
        		'condition' => false,
        		'content' => array()
        	),
        	'text' => _t('_sys_top_menu_more'),
        	'sub_menus' => ''
        ));
    }

    function GenMoreElementEnd()
    {
        return "";
    }
	    function genBreadcrumb($aPath = array())
    {
        $sRootItem = '<a href="' . $this->sSiteUrl . '">' . _t('_Home') . '</a>';

        if (!empty($this->aCustomBreadcrumbs)) {
            $a = array();
            foreach ($this->aCustomBreadcrumbs as $sTitle => $sLink)
                if ($sTitle)
                    $a[] = $sLink ? '<a href="' . $sLink . '">' . $sTitle . '</a>' : $sTitle;
            $aPath = array_merge(array($sRootItem), $a);
        } elseif(!is_array($aPath) || empty($aPath)) {
            $aPath = array($sRootItem);
        } else {
            $aPath = array_merge(array($sRootItem), $aPath);
        }

        //define current url for single page (not contain any child pages)
        if( $this -> aMenuInfo['currentTop'] != -1 && count($aPath) == 1) {
            $aPath[] =  _t($this -> aTopMenu[ $this -> aMenuInfo['currentTop'] ]['Caption']);
        }

        //--- Get breadcrumb path(left side) ---//
        $sDivider = '<div class="bc_divider bx-def-margin-sec-left"><span class="sys-icon caret-right"></span></div>';
        $aPathLinks = array();
        foreach($aPath as $sLink)
            $aPathLinks[] = '<div class="bc_unit bx-def-margin-sec-left">' . $sLink . '</div>';
        $sPathLinks = implode($sDivider, $aPathLinks);

        //--- Get additional links(right side) ---//
        $sAddons = "";
        return '<div class="sys_bc bx-def-margin-leftright">' . $sPathLinks . '<div class="bc_addons">' . $sAddons . '</div></div>';
    }

    function getCode()
    {
        global $oSysTemplate;

        if(isset($GLOBALS['bx_profiler']))
            $GLOBALS['bx_profiler']->beginMenu('Main Menu');

        $this->getMenuInfo();

        //--- Main Menu ---//
        $sMainMenu = $this->genTopItems();

        //--- Submenu Menu ---//
        $sSubMenu = '';
       if(!defined('BX_INDEX_PAGE') && !defined('BX_JOIN_PAGE'))
            $sSubMenu = $this->genSubMenus();

       if(!isMember() && (defined('BX_INDEX_PAGE')))
            $sSubMenu = $this->genSubMenus();

        $sResult = $oSysTemplate->parseHtmlByName('navigation_menu.html', array(
            'main_menu' => $sMainMenu,
            'sub_menu' => $sSubMenu
        ));

        if(isset($GLOBALS['bx_profiler']))
            $GLOBALS['bx_profiler']->endMenu('Main Menu');

        return $sResult;
    }

    /*
    * Generate sub menu elements
    */
    function genSubMenus()
    {
        foreach( $this->aTopMenu as $iTItemID => $aTItem ) {
            if( $aTItem['Type'] != 'top' && $aTItem['Type'] !='system')
                continue;

            if( !$this->checkToShow( $aTItem ) )
                continue;

            if($this->aMenuInfo['currentTop'] == -1) $this->aMenuInfo['currentTop'] = 5;

            if( $this->aMenuInfo['currentTop'] == $iTItemID && $this->checkShowCurSub() )
                $sDisplay = 'block';
            else {
                $sDisplay = 'none';
                if ($aTItem['Caption']=='_Home' && $this->aMenuInfo['currentTop']==0)
                    $sDisplay = 'block';
            }

            $sCaption = _t( $aTItem['Caption'] );
            $sCaption = $this->replaceMetas($sCaption);

            //generate
            if ($sDisplay == 'block') {
                $sPicture = $aTItem['Picture'];

                $iFirstID = $this->genSubFirstItem( $iTItemID );
                $this->genSubHeader( $iTItemID, $iFirstID, $sCaption, $sDisplay, $sPicture );
            }
        }

        return $GLOBALS['oSysTemplate']->parseHtmlByName('navigation_menu_sub.html', array(
        	'sub_menu' => $this->sCode
        ));
    }


}

// Creating template navigation menu class instance
$oTopMenu = new BxTemplMenu();
