<?php

require_once( BX_DIRECTORY_PATH_BASE . 'scripts/BxBaseCmtsView.php' );

/**
 * @see BxDolCmts
 */
class BxTemplCmtsView extends BxBaseCmtsView
{
    function BxTemplCmtsView( $sSystem, $iId, $iInit = 1 )
    {
        BxBaseCmtsView::BxBaseCmtsView( $sSystem, $iId, $iInit );
    }

    function _getActionsBox(&$a, $isJustPosted)
    {
        $n = $this->getAllowedEditTime();
        $isEditAllowedPermanently = ($a['cmt_author_id'] == $this->_getAuthorId() && $this->isEditAllowed()) || $this->isEditAllowedAll();
        $isRemoveAllowedPermanently = ($a['cmt_author_id'] == $this->_getAuthorId() && $this->isRemoveAllowed()) || $this->isRemoveAllowedAll();

        $sRet = '<tr id="cmt-jp-'.$a['cmt_id'].'" class="cmt-foot bx-def-font-small"><td class="' . $this->_sStylePrefix . '-cont-l">&nbsp;</td><td class="' . $this->_sStylePrefix . '-cont-m">';
        $sRet .= '<span class="cmt-posted-ago">' . $a['cmt_ago'] . '</span>';

        if($this->_aSystem['is_mood'])
            $sRet .= '<span class="sys-icon bullet"></span><span class="cmt-mood-text">' . _t($this->_aMoodText[$a['cmt_mood']]) . '</span>';

        if($isRemoveAllowedPermanently)
            $sRet .= '<span class="sys-icon bullet"></span><a class="cmt-comment-manage-delete" title="' . _t('_Delete') . '" href="javascript:void(0)" onclick="' . $this->_sJsObjName . '.cmtRemove(this, \'' . $a['cmt_id'] . '\'); return false;">'._t('_Delete').'</a>';

        if((($isJustPosted && $n) || $isEditAllowedPermanently) && strpos($a['cmt_text'], 'video_comments') === false)
            $sRet .= '<span class="sys-icon bullet"></span><a class="cmt-comment-manage-edit" title="'._t('_Edit').'" href="javascript:void(0)" onclick="' . $this->_sJsObjName . '.cmtEdit(this, \'' . $a['cmt_id'] . '\'); return false;">'._t('_Edit').'</a>';

        if($a['cmt_replies'])
            $sRet .= '<span class="sys-icon bullet"></span>' . $this->_getRepliesBox($a);

        if(!$isJustPosted && $this->isPostReplyAllowed())
            $sRet .= '<span class="sys-icon bullet"></span>' . $this->_getPostReplyBoxTo($a);

        if ($isJustPosted && $n && !$isEditAllowedPermanently)
            $sRet .= '<span class="sys-icon bullet"></span>' . _t('_edit_available_for_N_seconds', $n);

        $sRet .= '</td><td class="' . $this->_sStylePrefix . '-cont-r">&nbsp;</td></tr>';
        return $sRet;
    }

}
