<?php
/**
 * Copyright (c) BoonEx Pty Limited - http://www.boonex.com/
 * CC-BY License - http://creativecommons.org/licenses/by/3.0/
 */

bx_import('BxDolPageView');

class BxBastardsPageMy extends BxDolPageView
{
    var $_oMain;
    var $_oTemplate;
    var $_oDb;
    var $_oConfig;
    var $_aProfile;

    function BxBastardsPageMy(&$oMain, &$aProfile)
    {
        $this->_oMain = &$oMain;
        $this->_oTemplate = $oMain->_oTemplate;
        $this->_oDb = $oMain->_oDb;
        $this->_oConfig = $oMain->_oConfig;
        $this->_aProfile = $aProfile;
        parent::BxDolPageView('bx_bastards_my');
    }

    function getBlockCode_Owner()
    {
        if (!$this->_oMain->_iProfileId || !$this->_aProfile)
            return '';

        $sContent = '';
        switch (bx_get('bx_bastards_filter')) {
        case 'add_bastard':
            $sContent = $this->getBlockCode_Add ();
            break;
        case 'manage_bastards':
            $sContent = $this->getBlockCode_My ();
            break;
        case 'pending_bastards':
            $sContent = $this->getBlockCode_Pending ();
            break;
        default:
            $sContent = $this->getBlockCode_Main ();
        }

        $sBaseUrl = BX_DOL_URL_ROOT . $this->_oConfig->getBaseUri() . "browse/my";
        $aMenu = array(
            _t('_bx_bastards_block_submenu_main') => array('href' => $sBaseUrl, 'active' => !bx_get('bx_bastards_filter')),
            _t('_bx_bastards_block_submenu_add_bastard') => array('href' => $sBaseUrl . '&bx_bastards_filter=add_bastard', 'active' => 'add_bastard' == bx_get('bx_bastards_filter')),
            _t('_bx_bastards_block_submenu_manage_bastards') => array('href' => $sBaseUrl . '&bx_bastards_filter=manage_bastards', 'active' => 'manage_bastards' == bx_get('bx_bastards_filter')),
            _t('_bx_bastards_block_submenu_pending_bastards') => array('href' => $sBaseUrl . '&bx_bastards_filter=pending_bastards', 'active' => 'pending_bastards' == bx_get('bx_bastards_filter')),
        );
        return array($sContent, $aMenu, '', '');
    }

    function getBlockCode_Browse()
    {
        bx_bastards_import ('SearchResult');
        $o = new BxBastardsSearchResult('user', process_db_input ($this->_aProfile['NickName'], BX_TAGS_NO_ACTION, BX_SLASHES_NO_ACTION));
        $o->aCurrent['rss'] = 0;

        $o->sBrowseUrl = "browse/my";
        $o->aCurrent['title'] = _t('_bx_bastards_page_title_my_bastards');

        if ($o->isError) {
            return DesignBoxContent(_t('_bx_bastards_block_users_bastards'), MsgBox(_t('_Empty')), 1);
        }

        if ($s = $o->processing()) {
            $this->_oTemplate->addCss (array('unit.css', 'twig.css', 'main.css'));
            return $s;
        } else {
            return DesignBoxContent(_t('_bx_bastards_block_users_bastards'), MsgBox(_t('_Empty')), 1);
        }
    }

    function getBlockCode_Main()
    {
        $iActive = $this->_oDb->getCountByAuthorAndStatus($this->_aProfile['ID'], 'approved');
        $iPending = $this->_oDb->getCountByAuthorAndStatus($this->_aProfile['ID'], 'pending');
        $sBaseUrl = BX_DOL_URL_ROOT . $this->_oConfig->getBaseUri() . "browse/my";
        $aVars = array ('msg' => '');
        if ($iPending)
            $aVars['msg'] = sprintf(_t('_bx_bastards_msg_you_have_pending_approval_bastards'), $sBaseUrl . '&bx_bastards_filter=pending_bastards', $iPending);
        elseif (!$iActive)
            $aVars['msg'] = sprintf(_t('_bx_bastards_msg_you_have_no_bastards'), $sBaseUrl . '&bx_bastards_filter=add_bastard');
        else
            $aVars['msg'] = sprintf(_t('_bx_bastards_msg_you_have_some_bastards'), $sBaseUrl . '&bx_bastards_filter=manage_bastards', $iActive, $sBaseUrl . '&bx_bastards_filter=add_bastard');
        return $this->_oTemplate->parseHtmlByName('my_bastards_main', $aVars);
    }

    function getBlockCode_Add()
    {
        if (!$this->_oMain->isAllowedAdd()) {
            return MsgBox(_t('_Access denied'));
        }
        ob_start();
        $this->_oMain->_addForm(BX_DOL_URL_ROOT . $this->_oConfig->getBaseUri() . 'browse/my');
        $aVars = array ('form' => ob_get_clean(), 'id' => '');
        $this->_oTemplate->addCss ('forms_extra.css');
        return $this->_oTemplate->parseHtmlByName('my_bastards_create_bastard', $aVars);
    }

    function getBlockCode_Pending()
    {
        $sForm = $this->_oMain->_manageEntries ('my_pending', '', false, 'bx_bastards_pending_user_form', array(
            'action_delete' => '_bx_bastards_admin_delete',
        ), 'bx_bastards_my_pending', false, 7);
        if (!$sForm)
            return MsgBox(_t('_Empty'));
        $aVars = array ('form' => $sForm, 'id' => 'bx_bastards_my_pending');
        return $this->_oTemplate->parseHtmlByName('my_bastards_manage', $aVars);
    }

    function getBlockCode_My()
    {
        $sForm = $this->_oMain->_manageEntries ('user', process_db_input ($this->_aProfile['NickName'], BX_TAGS_NO_ACTION, BX_SLASHES_NO_ACTION), false, 'bx_bastards_user_form', array(
            'action_delete' => '_bx_bastards_admin_delete',
        ), 'bx_bastards_my_active', true, 7);
        $aVars = array ('form' => $sForm, 'id' => 'bx_bastards_my_active');
        return $this->_oTemplate->parseHtmlByName('my_bastards_manage', $aVars);
    }
}
