<?php

/**
 * Copyright (c) BoonEx Pty Limited - http://www.boonex.com/
 * CC-BY License - http://creativecommons.org/licenses/by/3.0/
 */

bx_import('BxBaseMenu');

/**
* @see BxBaseMenu;
*/
class BxTemplMenu extends BxBaseMenu {

	/**
	* Class constructor;
	*/
	function BxTemplMenu() {
		parent::BxBaseMenu();
	}



	/*
	* Generate top menu elements
	*/
    function genTopItem($sText, $sLink, $sTarget, $sOnclick, $bActive, $iItemID, $isBold = false, $sPicture = '') {
        
		$sActiveStyle = ($bActive) ? ' id="tm_active"' : '';

		if (!$bActive) {
			$sOnclick = $sOnclick ? ( ' onclick="' . $sOnclick . '"' ) : '';
			$sTarget  = $sTarget  ? ( ' target="'  . $sTarget  . '"' ) : '';
		}

		$sLink = (strpos($sLink, 'http://') === false && !strlen($sOnclick)) ? $this->sSiteUrl . $sLink : $sLink;

		$sMoreIcon = getTemplateIcon('tm_sitem_down.gif');

		$sSubMenu = $this->getAllSubMenus($iItemID);

		$sBoldStyle = ($isBold) ? 'style="font-weight:bold;"' : '';

		$sImgTabStyle = $sPictureRep = '';
		if ($isBold && $sPicture != '') {
			$sPicturePath = getTemplateIcon($sPicture);
			$sPictureRep = '<img src="' . $sPicturePath . '" />';

			$sText = '';
			$sImgTabStyle = 'style="width:38px;"';
		}

//$aText = _t('_dropMenu_' . $sText);
$tContent2 = _t('_dropMenu_Content2_' . $sText);
$tContent1 = _t('_dropMenu_Content1_' . $sText);
$tLeftContent = _t('_Left_Content_' . $sText);
$tBotLeftContent = _t('_Bot_Left_' . $sText);
		$sMainSubs = ($sSubMenu=='') ? '' : <<<EOF

	<ul class="sub main_elements "><div id="subMenuHead"><h3>{$sText}<button style="float:right" class="menuClose">Close Menu</button></h3>
<script>
$(document).ready(function(){
  $("button").click(function(){
    $("ul").addClass("ulClose");
  });
});
$(document).ready(function(){
  $("button").mouseout(function(){
    $("ul").removeClass("ulClose");
  });
});
</script>
<style>
.ulClose {
display:none !important;
}

.menuClose {
background: #101010;
border:1px solid #333333;
padding:4px;
border-radius:4px;
color:#00aa00;
text-transform:none;
}

.menuClose:hover {
background: #151515;
color:#cc0000;
cursor:pointer;
}
</style>

<div class="oval2"></div>
</div>
<div id="SubMenuLeftCol" class="SubMenuLeftCol_{$sText}">{$sSubMenu}<div style="width:100%;height:2px;clear:both;"></div></div>
<div id="bottomLeft" class="bottomLeft{$sText}">{$tBotLeftContent}</div>
<div id="subMenuMiddleCol"  class="SubMenuMiddleCol_{$sText}">{$tContent1}</div>
<div id="subMenuRightCol" class="SubMenuRightCol_{$sText}">{$tContent2}</div>
	</ul>

EOF;

		$this->sCode .= <<<EOF
<td class="top" {$sActiveStyle} {$sImgTabStyle}>
	<a href="{$sLink}" {$sOnclick} {$sTarget} class="top_link"><span class="down" {$sBoldStyle}>{$sPictureRep}{$sText}</span>
	<!--[if gte IE 7]><!--></a><!--<![endif]-->
	<div id="dropdownTwoColumn">{$sMainSubs}</div>
</td>
EOF;
	}

	function GenMoreElementBegin() {
		$sMoreIcon = getTemplateIcon("tm_sitem_down.gif");

		$sMoreMainIcon = getTemplateIcon('tm_item_more.png');
		$moreText = _t('_dropMenu_MoreHead');
		$this->sCode .= <<<EOF
		<td class="top" style="width:68px;">
		<a href="javascript: void(0);" onclick="void(0);" class="top_link">
		<span class="down">More<img style ="margin-top:10px !important" src="{$sMoreMainIcon}"/></span>
		<!--[if gte IE 7]><!--></a><!--<![endif]-->
		<!--[if lte IE 6]><table id="mmm"><tr><td><![endif]-->
		<div id="dropdownTwoColumn"  style="position:relative;display:block;">
        <ul class="sub main_elements"><div id="subMenuHead"><h3>{$moreText}</h3></div><div id="SubMenuLeftCol">

EOF;
	}

	function genTopItemMore($sText, $sLink, $sTarget, $sOnclick, $bActive, $iItemID) {
		//$sIActiveStyles = ($bActive) ? 'color:#333;font-weight:bold;' : '';
        $sIActiveClass = ($bActive) ? ' active' : '';
		$sITarget = (strlen($sTarget)) ? $sTarget : '_self';
		$sILink = (strpos($sLink, 'http://') === false && !strlen($sOnclick)) ? $this->sSiteUrl . $sLink : $sLink;
		//$sIOnclick = (strlen($sOnclick)) ? $sOnclick : "window.open('{$sILink}','{$sITarget}');"; //old version
        $sIOnclick = (strlen($sOnclick)) ? 'onclick="'.$sOnclick.'"' : '';

		$sSubMenu = $this->getAllSubMenus($iItemID);

		$sActiveStyle = ($bActive) ? 'active' : '';
		$sActiveVisibleStyle = ($bActive) ? 'display:block;' : 'display:none;';
		$sSpacerIcon = getTemplateIcon( 'spacer.gif' );

		$this->iJSTempCnt++;

		if ($sSubMenu == '') {
			$this->sCode .= <<<EOF
<li class="{$sActiveStyle}">
	<a href="{$sILink}" {$sIOnclick} value="{$sText}" class="button more_ntop_element{$sIActiveClass}">{$sText}</a>
</li>
EOF;
		} else {
			$this->sCode .= <<<EOF
<li class="{$sActiveStyle}">

	<a href="{$sILink}" {$sIOnclick} value="{$sText}" class="button more_top_element{$sIActiveClass}" style="margin-left:0px;">{$sText}</a>
    <div class="clear_both"></div>
    	
	<ul style="{$sActiveVisibleStyle}" id="ul{$this->iJSTempCnt}" class="more_sub">
		{$sSubMenu}
	</ul>    
</li>
EOF;
		}
		$this->iJSTempCnt++;
	}



	function GenMoreElementEnd() {
		$moreContent2 = _t('_dropMenu_MoreContent2');
		$moreContent1 = _t('_dropMenu_MoreContent1');
		$moreBotLeft = _t('_Bot_Left_More');
		$this->sCode .= <<<EOF
</div>
<div id="bottomLeft" class="bottomLeftMore">{$moreBotLeft}</div>
<div id="subMenuMiddleCol"  class="SubMenuMiddleCol_{$sText}">{$moreContent2}</div>
<div id="subMenuRightCol">{$moreContent2}</div>
    	</ul>
	</div>
	<div class="clear_both"></div>

</td>
EOF;
	}

}

// Creating template navigation menu class instance
$oTopMenu = new BxTemplMenu();
