function BxFaqMain(oOptions) {
    this._sSystem = oOptions.sSystem;
    this._sActionsUrl = oOptions.sActionUrl;
    this._sObjName = oOptions.sObjName == undefined ? 'oFaqMain' : oOptions.sObjName;
    this._sAnimationEffect = oOptions.sAnimationEffect == undefined ? 'slide' : oOptions.sAnimationEffect;
    this._iAnimationSpeed = oOptions.iAnimationSpeed == undefined ? 'slow' : oOptions.iAnimationSpeed;
}
BxFaqMain.prototype.changePage = function(iStart, iPerPage, sType, sTypeParams) {
	var $this = this;
    var oDate = new Date();    
    var oParams = {
    	_t:oDate.getTime()
    }

    if(sTypeParams)
    	oParams['params'] = sTypeParams;

    if($('#faqs-filter-chb:checked').length > 0 && $('#faqs-filter-txt').val().length > 0)
    	oParams['filter_value'] = $('#faqs-filter-txt').val();

    var sLoadingId = '#faqs-' + sType + '-loading'; 
    $(sLoadingId).bx_loading();

    $.post(
        this._sActionsUrl + 'act_get_faqs/' + (sType ? sType + '/' : '') + iStart + '/' + iPerPage + '/',
        oParams,
        function(sData) {
        	$(sLoadingId).bx_loading();

            $('.faq-view #faq-content-' + sType).bx_anim('hide', $this._sAnimationEffect, $this._iAnimationSpeed, function() {
                $(this).replaceWith(sData);
            });            
        },
        'html'
    );
}
BxFaqMain.prototype.deleteEntry = function(iId) {
	var $this = this;
	
	$.post(
		this._sActionsUrl + "act_delete/",
		{id:iId},
		function(sData) {
			var iCode = parseInt(sData);
			if(iCode == 1) {
				alert(aDolLang['_faqs_msg_success_delete']);
				window.location.href = $this._sActionsUrl
			}
			else
				alert(aDolLang['_faqs_msg_failed_delete']);
		}
	)
}