<?php
/**
 * Copyright (c) BoonEx Pty Limited - http://www.boonex.com/
 * CC-BY License - http://creativecommons.org/licenses/by/3.0/
 */

bx_import('BxDolTextModule');

require_once('BxFaqCalendar.php');
require_once('BxFaqCmts.php');
require_once('BxFaqVoting.php');
require_once('BxFaqSearchResult.php');
require_once('BxFaqData.php');

/**
 * Faqs module by BoonEx
 *
 * This module is needed to manage site faqs.
 *
 *
 * Profile's Wall:
 * no spy events
 *
 *
 *
 * Spy:
 * no spy events
 *
 *
 *
 * Memberships/ACL:
 * Doesn't depend on user's membership.
 *
 *
 *
 * Service methods:
 *
 * Get post block.
 * @see BxFaqModule::servicePostBlock
 * BxDolService::call('faqs', 'post_block');
 * @note is needed for internal usage.
 *
 * Get edit block.
 * @see BxFaqModule::serviceEditBlock
 * BxDolService::call('faqs', 'edit_block', array($mixed));
 * @note is needed for internal usage.
 *
 * Get administration block.
 * @see BxFaqModule::serviceAdminBlock
 * BxDolService::call('faqs', 'admin_block', array($iStart, $iPerPage, $sFilterValue));
 * @note is needed for internal usage.
 *
 * Get block with all faqs ordered by the time of posting.
 * @see BxFaqModule::serviceArchiveBlock
 * BxDolService::call('faqs', 'archive_block', array($iStart, $iPerPage));
 * @note is needed for internal usage.
 *
 * Get block with faqs marked as featured.
 * @see BxFaqModule::serviceFeaturedBlock
 * BxDolService::call('faqs', 'featured_block', array($iStart, $iPerPage));
 * @note is needed for internal usage.
 *
 * Get block with faqs ordered by their rating.
 * @see BxFaqModule::serviceTopRatedBlock
 * BxDolService::call('faqs', 'top_rated_block', array($iStart, $iPerPage));
 * @note is needed for internal usage.
 *
 * Get block with all faqs ordered by their popularity(number of views).
 * @see BxFaqModule::servicePopularBlock
 * BxDolService::call('faqs', 'popular_block', array($iStart, $iPerPage));
 * @note is needed for internal usage.
 *
 *
 * Alerts:
 * Alerts type/unit - 'faqs'
 * The following alerts are rised
 *
 *  post - faq is added
 *      $iObjectId - faq id
 *      $iSenderId - admin's id
 *
 *  edit - faq was modified
 *      $iObjectId - faq id
 *      $iSenderId - admin's id
 *
 *  featured - faq was marked as featured
 *      $iObjectId - faq id
 *      $iSenderId - admin's id
 *
 *  publish - faq was published
 *      $iObjectId - faq id
 *      $iSenderId - admin's id
 *
 *  unpublish - faq was unpublished
 *      $iObjectId - faq id
 *      $iSenderId - admin's id
 *
 *  delete - faq was deleted
 *      $iObjectId - faq id
 *      $iSenderId - admin's id
 *
 */
class BxFaqModule extends BxDolTextModule
{
    /**
     * Constructor
     */
    function BxFaqModule($aModule)
    {
        parent::BxDolTextModule($aModule);

        //--- Define Membership Actions ---//
        defineMembershipActions(array('faqs delete'), 'ACTION_ID_');
    }

    /**
     * Service methods
     */
    function serviceFaqsRss($iLength = 0)
    {
        return $this->actionRss($iLength);
    }

    /**
     * Action methods
     */
    function actionGetFaqs($sSampleType = 'all', $iStart = 0, $iPerPage = 0)
    {
        return $this->actionGetEntries($sSampleType, $iStart, $iPerPage);
    }

    /**
     * Private methods.
     */
    function _createObjectCalendar($iYear, $iMonth)
    {
        return new BxFaqCalendar($iYear, $iMonth, $this->_oDb, $this->_oConfig);
    }
    function _createObjectCmts($iId)
    {
        return new BxFaqCmts($this->_oConfig->getCommentsSystemName(), $iId);
    }
    function _createObjectVoting($iId)
    {
        return new BxFaqVoting($this->_oConfig->getVotesSystemName(), $iId);
    }
    function _isDeleteAllowed($bPerform = false)
    {
        if(!isLogged())
            return false;

        if(isAdmin())
            return true;

        $aCheckResult = checkAction(getLoggedId(), ACTION_ID_FAQS_DELETE, $bPerform);
        return $aCheckResult[CHECK_ACTION_RESULT] == CHECK_ACTION_RESULT_ALLOWED;
    }
}
