<?php
/**
 * Copyright (c) BoonEx Pty Limited - http://www.boonex.com/
 * CC-BY License - http://creativecommons.org/licenses/by/3.0/
 */

bx_import('BxDolTextModule');

require_once('BxDefCalendar.php');
require_once('BxDefCmts.php');
require_once('BxDefVoting.php');
require_once('BxDefSearchResult.php');
require_once('BxDefData.php');

/**
 * Definitions module by BoonEx
 *
 * This module is needed to manage site definitions.
 *
 *
 * Profile's Wall:
 * no spy events
 *
 *
 *
 * Spy:
 * no spy events
 *
 *
 *
 * Memberships/ACL:
 * Doesn't depend on user's membership.
 *
 *
 *
 * Service methods:
 *
 * Get post block.
 * @see BxDefModule::servicePostBlock
 * BxDolService::call('definitions', 'post_block');
 * @note is needed for internal usage.
 *
 * Get edit block.
 * @see BxDefModule::serviceEditBlock
 * BxDolService::call('definitions', 'edit_block', array($mixed));
 * @note is needed for internal usage.
 *
 * Get administration block.
 * @see BxDefModule::serviceAdminBlock
 * BxDolService::call('definitions', 'admin_block', array($iStart, $iPerPage, $sFilterValue));
 * @note is needed for internal usage.
 *
 * Get block with all definitions ordered by the time of posting.
 * @see BxDefModule::serviceArchiveBlock
 * BxDolService::call('definitions', 'archive_block', array($iStart, $iPerPage));
 * @note is needed for internal usage.
 *
 * Get block with definitions marked as featured.
 * @see BxDefModule::serviceFeaturedBlock
 * BxDolService::call('definitions', 'featured_block', array($iStart, $iPerPage));
 * @note is needed for internal usage.
 *
 * Get block with definitions ordered by their rating.
 * @see BxDefModule::serviceTopRatedBlock
 * BxDolService::call('definitions', 'top_rated_block', array($iStart, $iPerPage));
 * @note is needed for internal usage.
 *
 * Get block with all definitions ordered by their popularity(number of views).
 * @see BxDefModule::servicePopularBlock
 * BxDolService::call('definitions', 'popular_block', array($iStart, $iPerPage));
 * @note is needed for internal usage.
 *
 *
 * Alerts:
 * Alerts type/unit - 'definitions'
 * The following alerts are rised
 *
 *  post - definition is added
 *      $iObjectId - definition id
 *      $iSenderId - admin's id
 *
 *  edit - definition was modified
 *      $iObjectId - definition id
 *      $iSenderId - admin's id
 *
 *  featured - definition was marked as featured
 *      $iObjectId - definition id
 *      $iSenderId - admin's id
 *
 *  publish - definition was published
 *      $iObjectId - definition id
 *      $iSenderId - admin's id
 *
 *  unpublish - definition was unpublished
 *      $iObjectId - definition id
 *      $iSenderId - admin's id
 *
 *  delete - definition was deleted
 *      $iObjectId - definition id
 *      $iSenderId - admin's id
 *
 */
class BxDefModule extends BxDolTextModule
{
    /**
     * Constructor
     */
    function BxDefModule($aModule)
    {
        parent::BxDolTextModule($aModule);

        //--- Define Membership Actions ---//
        defineMembershipActions(array('definitions delete'), 'ACTION_ID_');
    }

    /**
     * Service methods
     */
    function serviceDefinitionsRss($iLength = 0)
    {
        return $this->actionRss($iLength);
    }

    /**
     * Action methods
     */
    function actionGetDefinitions($sSampleType = 'all', $iStart = 0, $iPerPage = 0)
    {
        return $this->actionGetEntries($sSampleType, $iStart, $iPerPage);
    }

    /**
     * Private methods.
     */
    function _createObjectCalendar($iYear, $iMonth)
    {
        return new BxDefCalendar($iYear, $iMonth, $this->_oDb, $this->_oConfig);
    }
    function _createObjectCmts($iId)
    {
        return new BxDefCmts($this->_oConfig->getCommentsSystemName(), $iId);
    }
    function _createObjectVoting($iId)
    {
        return new BxDefVoting($this->_oConfig->getVotesSystemName(), $iId);
    }
    function _isDeleteAllowed($bPerform = false)
    {
        if(!isLogged())
            return false;

        if(isAdmin())
            return true;

        $aCheckResult = checkAction(getLoggedId(), ACTION_ID_DEFINITIONS_DELETE, $bPerform);
        return $aCheckResult[CHECK_ACTION_RESULT] == CHECK_ACTION_RESULT_ALLOWED;
    }
}
