--
-- Table structure for table `[db_prefix]entries`
--

CREATE TABLE IF NOT EXISTS `[db_prefix]entries` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `author_id` int(11) unsigned NOT NULL default '0',  
  `caption` varchar(100) NOT NULL default '',
  `snippet` text NOT NULL,
  `content` mediumtext NOT NULL,
  `when` int(11) NOT NULL default '0',
  `uri` varchar(100) NOT NULL default '',
  `tags` varchar(255) NOT NULL default '',
  `categories` varchar(255) NOT NULL default '',
  `comment` tinyint(0) NOT NULL default '0',
  `vote` tinyint(0) NOT NULL default '0',
  `date` int(11) NOT NULL default '0',
  `status` tinyint(4) NOT NULL default '0',
  `featured` tinyint(4) NOT NULL default '0',
  `rate` int(11) NOT NULL default '0',
  `rate_count` int(11) NOT NULL default '0',
  `view_count` int(11) NOT NULL default '0',
  `cmts_count` int(11) NOT NULL default '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uri` (`uri`),
  FULLTEXT KEY `search_group` (`caption`, `content`, `tags`, `categories`),
  FULLTEXT KEY `search_caption` (`caption`),
  FULLTEXT KEY `search_content` (`content`),
  FULLTEXT KEY `search_tags` (`tags`),
  FULLTEXT KEY `search_categories` (`categories`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `[db_prefix]comments`
--

CREATE TABLE IF NOT EXISTS `[db_prefix]comments` (
  `cmt_id` int(11) NOT NULL auto_increment,
  `cmt_parent_id` int(11) NOT NULL default '0',
  `cmt_object_id` int(11) NOT NULL default '0',
  `cmt_author_id` int(10) unsigned NOT NULL default '0',
  `cmt_text` text NOT NULL,
  `cmt_mood` tinyint(4) NOT NULL default '0',
  `cmt_rate` int(11) NOT NULL default '0',
  `cmt_rate_count` int(11) NOT NULL default '0',
  `cmt_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `cmt_replies` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cmt_id`),
  KEY `cmt_object_id` (`cmt_object_id`,`cmt_parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `[db_prefix]comments_track`
--

CREATE TABLE IF NOT EXISTS `[db_prefix]comments_track` (
  `cmt_system_id` int(11) NOT NULL default '0',
  `cmt_id` int(11) NOT NULL default '0',
  `cmt_rate` tinyint(4) NOT NULL default '0',
  `cmt_rate_author_id` int(10) unsigned NOT NULL default '0',
  `cmt_rate_author_nip` int(11) unsigned NOT NULL default '0',
  `cmt_rate_ts` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cmt_system_id`,`cmt_id`,`cmt_rate_author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `[db_prefix]voting`
--
CREATE TABLE `[db_prefix]voting` (
  `def_id` bigint(8) NOT NULL default '0',
  `def_rating_count` int(11) NOT NULL default '0',
  `def_rating_sum` int(11) NOT NULL default '0',
  UNIQUE KEY `def_id` (`def_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `[db_prefix]voting_track`
--
CREATE TABLE `[db_prefix]voting_track` (
  `def_id` bigint(8) NOT NULL default '0',
  `def_ip` varchar(20) default NULL,
  `def_date` datetime default NULL,
  KEY `def_ip` (`def_ip`,`def_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `[db_prefix]views_track`
--
CREATE TABLE IF NOT EXISTS `[db_prefix]views_track` (
  `id` int(10) unsigned NOT NULL,
  `viewer` int(10) unsigned NOT NULL,
  `ip` int(10) unsigned NOT NULL,
  `ts` int(10) unsigned NOT NULL,
  KEY `id` (`id`,`viewer`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


SET @iTMOrder = (SELECT MAX(`Order`) FROM `sys_menu_top` WHERE `Parent`='0');
INSERT INTO `sys_menu_top` (`Parent`, `Name`, `Caption`, `Link`, `Order`, `Visible`, `Target`, `Onclick`, `Check`, `Editable`, `Deletable`, `Active`, `Type`, `Picture`, `BQuickLink`, `Statistics`) VALUES
(0, 'Definitions', '_definitions_top_menu_item', 'modules/?r=definitions/index/|modules/?r=definitions/', @iTMOrder+1, 'non,memb', '', '', '', 1, 1, 1, 'top', 'file', 0, '');

SET @iTMParentId = LAST_INSERT_ID( );
INSERT INTO `sys_menu_top` (`Parent`, `Name`, `Caption`, `Link`, `Order`, `Visible`, `Target`, `Onclick`, `Check`, `Editable`, `Deletable`, `Active`, `Type`, `Picture`, `BQuickLink`, `Statistics`) VALUES
(@iTMParentId, 'DefinitionsHome', '_definitions_home_top_menu_sitem', 'modules/?r=definitions/index/', 0, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(@iTMParentId, 'DefinitionsArchive', '_definitions_archive_top_menu_sitem', 'modules/?r=definitions/archive/', 1, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(@iTMParentId, 'DefinitionsTop', '_definitions_top_top_menu_sitem', 'modules/?r=definitions/top/', 2, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(@iTMParentId, 'DefinitionsPopular', '_definitions_popular_top_menu_sitem', 'modules/?r=definitions/popular/', 3, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(@iTMParentId, 'DefinitionsFeatured', '_definitions_featured_top_menu_sitem', 'modules/?r=definitions/featured/', 4, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(@iTMParentId, 'DefinitionsTags', '_definitions_tags_top_menu_sitem', 'modules/?r=definitions/tags/', 5, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(@iTMParentId, 'DefinitionsCategories', '_definitions_categories_top_menu_sitem', 'modules/?r=definitions/categories/', 6, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(@iTMParentId, 'DefinitionsCalendar', '_definitions_calendar_top_menu_sitem', 'modules/?r=definitions/calendar/', 7, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(@iTMParentId, 'DefinitionsSearch', '_definitions_search_top_menu_sitem', 'searchKeyword.php?type=bx_definitions', 8, 'non,memb', '', '', '', 1, 1, 1, 'custom', '', 0, ''),
(0, 'DefinitionsView', '_definitions_view_top_menu_sitem', 'modules/?r=definitions/view/', 0, 'non,memb', '', '', '', 1, 1, 1, 'system', 'file', 0, '');

SET @iOrder = (SELECT MAX(`order`) FROM `sys_menu_admin` WHERE `parent_id`='2');
INSERT INTO `sys_menu_admin`(`parent_id`, `name`, `title`, `url`, `description`, `icon`, `icon_large`, `check`, `order`) VALUES
(2, 'bx_definitions', '_definitions_admin_menu_sitem', '{siteUrl}modules/?r=definitions/admin/', 'For managing definitions', 'file', '', '', @iOrder+1);


INSERT INTO `sys_permalinks`(`standard`, `permalink`, `check`) VALUES('modules/?r=definitions/', 'm/definitions/', 'permalinks_module_definitions');


SET @iCategoryOrder = (SELECT MAX(`menu_order`) FROM `sys_options_cats`) + 1;
INSERT INTO `sys_options_cats` (`name` , `menu_order` ) VALUES ('Definitions', @iCategoryOrder);
SET @iCategoryId = LAST_INSERT_ID();

INSERT INTO `sys_options` (`Name`, `VALUE`, `kateg`, `desc`, `Type`, `check`, `err_text`, `order_in_kateg`) VALUES
('permalinks_module_definitions', 'on', 26, 'Enable friendly definitions permalink', 'checkbox', '', '', 0),
('category_auto_app_bx_definitions', 'on', 0, 'Autoapprove for categories', 'checkbox', '', '', 0),
('definitions_autoapprove', 'on', @iCategoryId, 'Publish definitions automatically', 'checkbox', '', '', 1),
('definitions_comments', 'on', @iCategoryId, 'Allow comments for definitions', 'checkbox', '', '', 2),
('definitions_votes', 'on', @iCategoryId, 'Allow votes for definitions', 'checkbox', '', '', 3),
('definitions_index_number', '10', @iCategoryId, 'The number of definitions on home page', 'digit', '', '', 4),
('definitions_member_number', '10', @iCategoryId, 'The number of definitions on account page', 'digit', '', '', 5),
('definitions_per_page', '10', @iCategoryId, 'The number of items shown on the page', 'digit', '', '', 6),
('definitions_rss_length', '10', @iCategoryId, 'The number of items shown in the RSS feed', 'digit', '', '', 7);

INSERT INTO `sys_objects_cmts` (`ObjectName`, `TableCmts`, `TableTrack`, `AllowTags`, `Nl2br`, `SecToEdit`, `PerView`, `IsRatable`, `ViewingThreshold`, `AnimationEffect`, `AnimationSpeed`, `IsOn`, `IsMood`, `RootStylePrefix`, `TriggerTable`, `TriggerFieldId`, `TriggerFieldComments`, `ClassName`, `ClassFile`) VALUES
('bx_definitions', '[db_prefix]comments', '[db_prefix]comments_track', 0, 1, 90, 10, 1, -3, 'none', 0, 1, 0, 'cmt', '[db_prefix]entries', 'id', 'cmts_count', 'BxDefCmts', 'modules/boonex/definitions/classes/BxDefCmts.php');

INSERT INTO `sys_objects_vote` (`ObjectName`, `TableRating`, `TableTrack`, `RowPrefix`, `MaxVotes`, `PostName`, `IsDuplicate`, `IsOn`, `className`, `classFile`, `TriggerTable`, `TriggerFieldRate`, `TriggerFieldRateCount`, `TriggerFieldId`, `OverrideClassName`, `OverrideClassFile`) VALUES
('bx_definitions', '[db_prefix]voting', '[db_prefix]voting_track', 'def_', 5, 'vote_send_result', 'BX_PERIOD_PER_VOTE', 1, '', '', '[db_prefix]entries', 'rate', 'rate_count', 'id', 'BxDefVoting', 'modules/boonex/definitions/classes/BxDefVoting.php');

INSERT INTO `sys_objects_tag` (`ObjectName`, `Query`, `PermalinkParam`, `EnabledPermalink`, `DisabledPermalink`, `LangKey`) VALUES
('bx_definitions', 'SELECT `tags` FROM `[db_prefix]entries` WHERE `id`={iID} AND `status`=0', 'permalinks_module_definitions', 'm/definitions/tag/{tag}', 'modules/?r=definitions/tag/{tag}', '_definitions_lcaption_tags');

INSERT INTO `sys_objects_categories` (`ObjectName`, `Query`, `PermalinkParam`, `EnabledPermalink`, `DisabledPermalink`, `LangKey`) 
VALUES ('bx_definitions', 'SELECT `categories` FROM `[db_prefix]entries` WHERE `id`=''{iID}'' AND `status`=''0''', 'permalinks_module_definitions', 'm/definitions/category/{tag}', 'modules/?r=definitions/category/{tag}', '_definitions_lcaption_categories');

INSERT INTO `sys_categories` (`Category`, `ID`, `Type`, `Owner`, `Status`) VALUES 
('Default', '0', 'bx_definitions', '0', 'active'),
('BoonEx Products', '0', 'bx_definitions', '0', 'active'),
('Some Useful Info', '0', 'bx_definitions', '0', 'active');

INSERT INTO `sys_objects_search` (`ObjectName`, `Title`, `ClassName`, `ClassPath`) VALUES
('bx_definitions', '_definitions_lcaption_search_object', 'BxDefSearchResult', 'modules/boonex/definitions/classes/BxDefSearchResult.php');

INSERT INTO `sys_objects_views`(`name`, `table_track`, `period`, `trigger_table`, `trigger_field_id`, `trigger_field_views`, `is_on`) VALUES
('bx_definitions', '[db_prefix]views_track', 86400, '[db_prefix]entries', 'id', 'view_count', 1);


SET @iPCPOrder = (SELECT MAX(`Order`) FROM `sys_page_compose_pages`);
INSERT INTO `sys_page_compose_pages`(`Name`, `Title`, `Order`) VALUES ('definitions_single', 'Single Definition', @iPCPOrder+1);

SET @iPCPOrder = (SELECT MAX(`Order`) FROM `sys_page_compose_pages`);
INSERT INTO `sys_page_compose_pages`(`Name`, `Title`, `Order`) VALUES ('definitions_home', 'Definitions Home', @iPCPOrder+1);

INSERT INTO `sys_page_compose` (`Page`, `PageWidth`, `Desc`, `Caption`, `Column`, `Order`, `Func`, `Content`, `DesignBox`, `ColWidth`, `Visible`, `MinWidth`) VALUES
('index', '1140px', 'Show list of featured definitions', '_definitions_bcaption_featured', 0, 0, 'PHP', 'return BxDolService::call(\'definitions\', \'featured_block_index\', array(0, 0, false));', 1, 71.9, 'non,memb', 0),
('index', '1140px', 'Show list of latest definitions', '_definitions_bcaption_latest', 0, 0, 'PHP', 'return BxDolService::call(\'definitions\', \'archive_block_index\', array(0, 0, false));', 1, 71.9, 'non,memb', 0),
('member', '1140px', 'Show list of featured definitions', '_definitions_bcaption_featured', 0, 0, 'PHP', 'return BxDolService::call(\'definitions\', \'featured_block_member\', array(0, 0, false));', 1, 71.9, 'memb', 0),
('member', '1140px', 'Show list of latest definitions', '_definitions_bcaption_latest', 0, 0, 'PHP', 'return BxDolService::call(\'definitions\', \'archive_block_member\', array(0, 0, false));', 1, 71.9, 'memb', 0),
('definitions_single', '1140px', 'Definitions main content', '_definitions_bcaption_view_main', 1, 0, 'Content', '', 1, 71.9, 'non,memb', 0),
('definitions_single', '1140px', 'Definitions comments', '_definitions_bcaption_view_comment', 1, 1, 'Comment', '', 1, 71.9, 'non,memb', 0),
('definitions_single', '1140px', 'Definitions actions', '_definitions_bcaption_view_action', 2, 0, 'Action', '', 1, 28.1, 'non,memb', 0),
('definitions_single', '1140px', 'Definitions rating', '_definitions_bcaption_view_vote', 2, 1, 'Vote', '', 1, 28.1, 'non,memb', 0),
('definitions_single', '1140px', 'Social sharing', '_sys_block_title_social_sharing', 2, 2, 'SocialSharing', '', 1, 28.1, 'non,memb', 0),
('definitions_home', '1140px', 'Definitions featured', '_definitions_bcaption_featured', 0, 0, 'Featured', '', 1, 71.9, 'non,memb', 0),
('definitions_home', '1140px', 'Definitions latest', '_definitions_bcaption_latest', 1, 1, 'Latest', '', 1, 71.9, 'non,memb', 0),
('definitions_home', '1140px', 'Definitions calendar', '_definitions_bcaption_calendar', 0, 0, 'Calendar', '', 1, 28.1, 'non,memb', 0),
('definitions_home', '1140px', 'Definitions categories', '_definitions_bcaption_categories', 2, 1, 'Categories', '', 1, 28.1, 'non,memb', 0),
('definitions_home', '1140px', 'Definitions tags', '_definitions_bcaption_tags', 2, 2, 'Tags', '', 1, 28.1, 'non,memb', 0);

INSERT INTO `sys_objects_actions`(`Caption`, `Icon`, `Url`, `Script`, `Eval`, `Order`, `Type`, `bDisplayInSubMenuHeader`) VALUES
('{sbs_definitions_title}', 'paper-clip', '', '{sbs_definitions_script}', '', 1, 'bx_definitions', 0),
('{del_definitions_title}', 'remove', '', '{del_definitions_script}', '', 2, 'bx_definitions', 0),
('{share_definitions_title}', 'share', '', '{share_definitions_script}', '', 3, 'bx_definitions', 0);

INSERT INTO `sys_sbs_types`(`unit`, `action`, `template`, `params`) VALUES
('bx_definitions', '', '', 'return BxDolService::call(\'definitions\', \'get_subscription_params\', array($arg1, $arg2, $arg3));'),
('bx_definitions', 'commentPost', 't_sbsDefinitionsComments', 'return BxDolService::call(\'definitions\', \'get_subscription_params\', array($arg1, $arg2, $arg3));');

INSERT INTO `sys_email_templates`(`Name`, `Subject`, `Body`, `Desc`, `LangID`) VALUES
('t_sbsDefinitionsComments', 'New Comments To An Definition', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p>The <a href="<ViewLink>">definition you subscribed to got new comments</a>!</p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Subscription: new comments to definition', 0);

INSERT INTO `sys_acl_actions`(`Name`, `AdditionalParamName`) VALUES ('Definitions Delete', '');

INSERT INTO `sys_cron_jobs` (`name`, `time`, `class`, `file`, `eval`) VALUES
('bx_definitions', '*/5 * * * *', 'BxDefCron', 'modules/boonex/definitions/classes/BxDefCron.php', '');

-- mobile
SET @iMaxOrderHomepage = (SELECT MAX(`order`)+1 FROM `sys_menu_mobile` WHERE `page` = 'homepage');
INSERT INTO `sys_menu_mobile` (`type`, `page`, `title`, `icon`, `action`, `action_data`, `eval_bubble`, `eval_hidden`, `order`, `active`) VALUES
('bx_definitions', 'homepage', '_definitions_bcaption_all', '{site_url}modules/boonex/definitions/templates/base/images/icons/mobile_icon.png', 100, '{xmlrpc_url}r.php?url=modules%2F%3Fr%3Ddefinitions%2Fmobile_latest_entries%2F&user={member_username}&pwd={member_password}', '', '', @iMaxOrderHomepage, 1);

-- site stats
SET @iStatSiteOrder := (SELECT `StatOrder` + 1 FROM `sys_stat_site` WHERE 1 ORDER BY `StatOrder` DESC LIMIT 1);
INSERT INTO `sys_stat_site` VALUES(NULL, 'def', 'definitions_ss', 'modules/?r=definitions/archive/', 'SELECT COUNT(`ID`) FROM `[db_prefix]entries` WHERE `status`=''0''', 'modules/?r=definitions/admin/', 'SELECT COUNT(`ID`) FROM `[db_prefix]entries` WHERE `status`=''1''', 'file', @iStatSiteOrder);

-- sitemap
SET @iMaxOrderSiteMaps = (SELECT MAX(`order`)+1 FROM `sys_objects_site_maps`);
INSERT INTO `sys_objects_site_maps` (`object`, `title`, `priority`, `changefreq`, `class_name`, `class_file`, `order`, `active`) VALUES
('bx_definitions', '_definitions_sitemap', '0.8', 'auto', 'BxDefSiteMaps', 'modules/boonex/definitions/classes/BxDefSiteMaps.php', @iMaxOrderSiteMaps, 1);

-- chart
SET @iMaxOrderCharts = (SELECT MAX(`order`)+1 FROM `sys_objects_charts`);
INSERT INTO `sys_objects_charts` (`object`, `title`, `table`, `field_date_ts`, `field_date_dt`, `query`, `active`, `order`) VALUES
('bx_definitions', '_definitions_chart', 'bx_def_entries', 'when', '', '', 1, @iMaxOrderCharts);

