function BxDefMain(oOptions) {
    this._sSystem = oOptions.sSystem;
    this._sActionsUrl = oOptions.sActionUrl;
    this._sObjName = oOptions.sObjName == undefined ? 'oDefMain' : oOptions.sObjName;
    this._sAnimationEffect = oOptions.sAnimationEffect == undefined ? 'slide' : oOptions.sAnimationEffect;
    this._iAnimationSpeed = oOptions.iAnimationSpeed == undefined ? 'slow' : oOptions.iAnimationSpeed;
}
BxDefMain.prototype.changePage = function(iStart, iPerPage, sType, sTypeParams) {
	var $this = this;
    var oDate = new Date();    
    var oParams = {
    	_t:oDate.getTime()
    }

    if(sTypeParams)
    	oParams['params'] = sTypeParams;

    if($('#definitions-filter-chb:checked').length > 0 && $('#definitions-filter-txt').val().length > 0)
    	oParams['filter_value'] = $('#definitions-filter-txt').val();

    var sLoadingId = '#definitions-' + sType + '-loading'; 
    $(sLoadingId).bx_loading();

    $.post(
        this._sActionsUrl + 'act_get_definitions/' + (sType ? sType + '/' : '') + iStart + '/' + iPerPage + '/',
        oParams,
        function(sData) {
        	$(sLoadingId).bx_loading();

            $('.def-view #def-content-' + sType).bx_anim('hide', $this._sAnimationEffect, $this._iAnimationSpeed, function() {
                $(this).replaceWith(sData);
            });            
        },
        'html'
    );
}
BxDefMain.prototype.deleteEntry = function(iId) {
	var $this = this;
	
	$.post(
		this._sActionsUrl + "act_delete/",
		{id:iId},
		function(sData) {
			var iCode = parseInt(sData);
			if(iCode == 1) {
				alert(aDolLang['_definitions_msg_success_delete']);
				window.location.href = $this._sActionsUrl
			}
			else
				alert(aDolLang['_definitions_msg_failed_delete']);
		}
	)
}