/**
*                            Orca Interactive Forum Script
*                              ---------------
*     Started             : Mon Mar 23 2006
*     Copyright           : (C) 2007 BoonEx Group
*     Website             : http://www.boonex.com
* This file is part of Orca - Interactive Forum Script
* Creative Commons Attribution 3.0 License
**/


/**
 * admin functionality
 */


/**
 * constructor
 */
function Admin (base, forum)
{	
	this._base = base;
	this._forum = forum;
}   



/**
 * edit categories admin page
 */
Admin.prototype.editCategories = function ()
{
	this._forum.loading ('Bitte warten');

	var $this = this;

	var h = function (r)
	{		
		var m = document.getElementById('orca_main');		

		m.innerHTML = r;

		$this._forum.stopLoading ();
	}

	new BxXslTransform(this._base + "?action=edit_categories", urlXsl + "edit_categories.xsl", h);

	document.h.makeHist('action=goto&edit_cats=1');

	return false;
}

/**
 * reported posts
 */
Admin.prototype.reportedPosts = function ()
{
	this._forum.loading ('Bitte warten');

	var $this = this;

	var h = function (r)
	{		
		var m = document.getElementById('orca_main');		

		m.innerHTML = r;

		$this._forum.stopLoading ();
	}

	new BxXslTransform(this._base + "?action=reported_posts", urlXsl + "forum_posts.xsl", h);

	return false;
}

/**
 * hidden posts
 */
Admin.prototype.hiddenPosts = function ()
{
	this._forum.loading ('Bitte warten');

	var $this = this;

	var h = function (r)
	{		
		var m = document.getElementById('orca_main');		

		m.innerHTML = r;

		$this._forum.stopLoading ();
	}

	new BxXslTransform(this._base + "?action=hidden_posts", urlXsl + "forum_posts.xsl", h);

	return false;
}

/**
 * hidden topics
 */
Admin.prototype.hiddenTopics = function ()
{
	this._forum.loading ('Bitte warten');

	var $this = this;

	var h = function (r)
	{		
		var m = document.getElementById('orca_main');		

		m.innerHTML = r;

		$this._forum.stopLoading ();
	}

	new BxXslTransform(this._base + "?action=show_hidden_topics", urlXsl + "forum_topics.xsl", h);

	return false;
}

/**
 * delete category
 *	@param id	category id
 */
Admin.prototype.delCat = function (cat_id)
{
	if (!confirm ('Bist du sicher, dass du diese Kategorie mit allen Foren, Themen und Beiträgen löschen willst?')) return false;

	var $this = this;

	var h = function (r)
	{						
        var ret = orca_get_xml_ret(r);
		if ('1' == ret)
		{
			alert ('Kategorie wurde gelöscht.');
			$this.editCategories();
			return;
		}

		alert ('Kategorie kann nicht gelöscht werden.');
	}	

	jQuery.ajax ({
		url: this._base + "?action=edit_category_del&cat_id="+cat_id,		
		dataType: 'text',
		type: 'POST',
		success: h
	});

	return true;
}

/**
 * delete forum
 *	@param forum_id	forum id
 */
Admin.prototype.delForum = function (forum_id)
{
	if (!confirm ('Bist du sicher, dass du dieses Forum mit allen Themen und Beiträgen löschen willst?')) return false;

	var $this = this;

	var h = function (r)
	{				
        var cat_uri = orca_get_xml_val ('cat_uri', r);
        var cat_id = orca_get_xml_val ('cat_id', r);
		if (cat_id > 0)
		{
	    	alert ('Forum wurde gelöscht');			
    		$this.selectCat(cat_uri, 'cat'+cat_id, true, true);            
			return;
		}
        alert ('Forum kann nicht gelöscht werden.');
	}

	jQuery.ajax ({
		url: this._base + "?action=edit_forum_del&forum_id="+forum_id,
		dataType: 'text',
		type: 'POST',
		success: h
	});

	return true;
}

/**
 * edit category
 *	@param id	category id
 */
Admin.prototype.editCat = function (cat_id)
{	
	var $this = this;

	var h = function (r)
	{			
		$this._forum.showHTML (r, 400, 200);
	}

	new BxXslTransform(this._base + "?action=edit_category&cat_id="+cat_id, urlXsl + "edit_cat_form.xsl", h);

	return true;
}

/**
 * new group
 */
Admin.prototype.newCat = function ()
{	
	var $this = this;

	var h = function (r)
	{			
		$this._forum.showHTML (r, 400, 200);
	}

	new BxXslTransform(this._base + "?action=edit_category&cat_id="+0, urlXsl + "edit_cat_form.xsl", h);

	return true;
}

/**
 * edit category
 *	@param cat_name	new group name
 *	@param cat_id	category id 
 */
Admin.prototype.editCatSubmit = function (cat_id, cat_name, cat_order, cat_expanded)
{
	var $this = this;

	var h = function (r)
	{								
        var ret = orca_get_xml_ret(r);
		if ('1' == ret)
		{
			if (cat_id > 0)
				alert ('Forengruppe wurde geändert.');
			else
				alert ('Neue Gruppe wurde hinzugefügt.');
			$this._forum.hideHTML();
			$this.editCategories();
			return false;
		}

		if (cat_id > 0)
			alert ('Forengruppe kann nicht geändert werden.');
		else
			alert ('Neue Forengruppe kann nicht hinzugefügt werden.');
		return false;
	}

    cat_name = encodeURIComponent (cat_name); 

	jQuery.ajax ({
		url: this._base + "?action=edit_category_submit&cat_id="+cat_id+"&cat_name="+cat_name+"&cat_order="+cat_order+"&cat_expanded="+(cat_expanded ? 1 :0),
		dataType: 'text',
		type: 'POST',
		success: h
	});

	return false;
}


/**
 * edit forum
 *	@param id	category id
 */
Admin.prototype.editForum = function (forum_id)
{	
	var $this = this;

	var h = function (r)
	{			
		$this._forum.showHTML (r, 400, 200);
	}

	new BxXslTransform(this._base + "?action=edit_forum&forum_id="+forum_id, urlXsl + "edit_forum_form.xsl", h);

	return true;
}


/**
 * new category
 */
Admin.prototype.newForum = function (cat_id)
{	
	var $this = this;

	var h = function (r)
	{			
		$this._forum.showHTML (r, 400, 200);
	}
	
	new BxXslTransform (this._base + "?action=edit_forum&forum_id=0&cat_id="+cat_id, urlXsl + "edit_forum_form.xsl", h);

	return true;
}


/**
 * edit forum
 *	@param forum_id	forum id
 *	@param title 	forum title
 *	@param desc 	forum description
 *	@param type 	forum type
 */
Admin.prototype.editForumSubmit = function (cat_id, cat_uri, forum_id, title, desc, type, order)
{
	var $this = this;

	var h = function (r)
	{		
        var ret = orca_get_xml_ret(r);
		if ('1' == ret)
		{
			if (forum_id > 0)
				alert ('Forum wurde geändert');
			else
				alert ('Neues Forum wurde hinzugefügt.');
			$this._forum.hideHTML();
			$this.selectCat (cat_uri, 'cat'+cat_id, true, true);			
			return false;
		}

		if (forum_id > 0)
			alert ('Forum kann nicht geändert werden.');
		else
			alert ('Neues Forum kann nicht hinzugefügt werden.');
		return false;
	}

    title = encodeURIComponent(title); 
    desc = encodeURIComponent(desc); 

	jQuery.ajax ({
		url: this._base + "?action=edit_forum_submit&cat_id="+cat_id+"&forum_id="+forum_id+"&title="+title+"&desc="+desc+"&type="+type+"&order="+order,
		dataType: 'text',
		type: 'POST',
		success: h
	});

	return false;
}


/**
 * returns new topic page XML
 */
Admin.prototype.selectCat = function (cat, id, force_show, force_reload)
{	
	var e = $('#'+id);

	if (!e.size()) {
		new BxError("Diese Kategorie ID ist nicht festgelegt.", "Lege bitte Kategorie IDs fest.");
		return false;
	}

    // hide category forums
    if (e.next("[cat="+cat+"]").size()) {
        e.nextAll("[cat="+cat+"]").fadeOut(this._forum._speed, 
                function () { 
                    $(this).remove(); 
                } 
        );
        e.find('div').css('background-position', '0px 0px');

        if (!force_show)
            return false;
    }

	this._forum.loading ('BITTE WARTEN');

	var $this = this;
	this._cat = cat;
	var h = function (r)
	{	
        e.after($('<table>'+r+'</table>').find('tr').hide());
        if (document.all)
            e.nextAll("[cat="+cat+"]").css('display', 'block');
        else
			e.nextAll("[cat="+cat+"]").fadeIn($this._forum._speed);
        e.find('div.colexp').css('background-position', '0px -32px');
		$this._forum.stopLoading ();
	}
	new BxXslTransform(this._base + "?action=list_forums_admin&cat=" + cat, urlXsl + "edit_cat_forums.xsl", h);

	return false;
}

/*
 * lock/unlock
 */
Admin.prototype.lock = function (topic_id, locked)
{				
	var $this = this;

	var h = function (r)
	{		
        var ret = orca_get_xml_ret(r);
        var eImg = document.getElementById('btn_lock_topic');
		if ('1' == ret)
		{                   
			alert ('Thema wurde geschlossen.');
            if (eImg) 
            {
                eImg.src = eImg.src.replace(/unlocked/,'locked');
                var eB = eImg.nextSibling;
                if (eB.tagName != 'B') eB = eB.nextSibling;
                //if (eB.tagName == 'B') eB.innerHTML = eB.innerHTML.replace(/Lock/,'Unlock');
            }
			return false;
		}
		if ('-1' == ret)
		{         
			alert ('Thema wurde freigeschalten.');
            if (eImg) 
            {
                eImg.src = eImg.src.replace(/locked/,'unlocked');
                var eB = eImg.nextSibling;
                if (eB.tagName != 'B') eB = eB.nextSibling;
                //if (eB.tagName == 'B') eB.innerHTML = eB.innerHTML.replace(/Unlock/,'Lock');
            }
			return false;
		}

		alert ('Only admin can lock/unlock topics');
		return false;
	}

	jQuery.ajax ({
		url: this._base + "?action=lock_topic&topic_id=" + topic_id + "&ts=" + (new Date()),
		dataType: 'text',
		type: 'POST',
		success: h
	});

	return false;
}

/*
 * compile language files
 */
Admin.prototype.compileLangs = function (sLang)
{

	var h = function (r)
	{						
        var ret = orca_get_xml_ret(r);
		if ('1' == ret)
		{                   
			alert ('Die Sprachdateien wurden übersetzt. ');
		}
		else
		{         
			alert ('Die Sprachdateien Übersetzung ist fehlgeschlagen. Bitte überprüfe die entsprechenden Berechtigungen.');
		}
		return false;
	}

	jQuery.ajax ({
		url: this._base + "?action=compile_langs&lang=" + sLang + "&ts=" + (new Date()),
		dataType: 'text',
		type: 'POST',
		success: h
	});

}


Admin.prototype.clearReport = function (id)
{
	var $this = this;
	var h = function (r) {		
        var ret = orca_get_xml_ret(r);
		if ('1' == ret) {
        	var m = $('#post_row_'+id);
        	if (!m) 
		        return false;
            m.fadeOut(this._speed, 
                function () { 
                    $(this).remove(); 
                } 
            );
			return false;
		}
		alert ('_Error occured');
		return false;
	}

	jQuery.ajax ({
		url: this._base + "?action=clear_report&post_id=" + id,
		dataType: 'text',
		type: 'POST',
		success: h
	});

	return false;	
}
